package gov.va.genisis2.converter;

import java.io.File;
import java.io.IOException;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import gov.va.genisis2.dto.AttachmentDTO;
import gov.va.genisis2.model.Attachment;

/**
 * This class is used to convert AttachementDTO to Attachement entity and
 * vice-versa.
 * 
 * @author PII
 *
 */
@Component
public class AttachmentConverter implements Converter<Attachment, AttachmentDTO> {

	@Override
	public AttachmentDTO convert(Attachment attachment) {

		AttachmentDTO attachmentDTO = new AttachmentDTO();
		attachmentDTO.setAttachmentId(attachment.getAttachmentId());
		attachmentDTO.setName(attachment.getName());
		attachmentDTO.setFileData(attachment.getFileData());
		attachmentDTO.setRequestId(attachment.getRequest().getId());
		attachmentDTO.setCreatedBy(attachment.getCreatedBy());
		attachmentDTO.setCreatedOn(attachment.getCreatedOn());
		attachmentDTO.setStatus(attachment.getStatus());
		attachmentDTO.setDescription(attachment.getDescription());
		attachmentDTO.setType(attachment.getType());
		//attachmentDTO.setTaskId("1");
		return attachmentDTO;
	}

	
	public AttachmentDTO convertToAttachmentDTO(String jsonString, MultipartFile file) {

		AttachmentDTO attachmentDTO = new AttachmentDTO();
		
		byte[] bytes = null;
		String fileXtn = StringUtils.EMPTY;
		String filePrimaryName = StringUtils.EMPTY;
		String fileName = StringUtils.EMPTY;
		if (!file.isEmpty()) {
			try {
				fileXtn = file.getOriginalFilename().split("\\.")[1];
				fileName = file.getOriginalFilename().split("\\.")[0];
				fileName = file.getOriginalFilename();
				bytes = file.getBytes();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		/*{
		    "requestId" : 1,
		    "comment": "This is comment for request 123444 hello",
		    "status": "Sent",
		    "createdBy": "datamanager1"
		}*/
		
		JSONObject json = new JSONObject(jsonString);
		int requestId = (int) json.get("requestId");
		String createdBy = (String) json.get("createdBy");
		String status = (String) json.get("status");
		
		attachmentDTO.setName(fileName);
		attachmentDTO.setFileData(bytes);
		attachmentDTO.setRequestId(requestId);
		attachmentDTO.setCreatedBy(createdBy);
	//	attachmentDTO.setCreatedOn(attachment.getCreatedOn());
		attachmentDTO.setStatus(status);
	//	attachmentDTO.setDescription(attachment.getDescription());
		attachmentDTO.setType(fileXtn);
		
		
		
		  
		/*attachmentDTO.setAttachmentId(attachment.getAttachmentId());
		attachmentDTO.setName(attachment.getName());
		attachmentDTO.setFileData(attachment.getFileData());
		attachmentDTO.setRequestId(attachment.getRequest().getId());
		attachmentDTO.setCreatedBy(attachment.getCreatedBy());
		attachmentDTO.setCreatedOn(attachment.getCreatedOn());
		attachmentDTO.setStatus(attachment.getStatus());
		attachmentDTO.setDescription(attachment.getDescription());
		attachmentDTO.setType(attachment.getType());
		//attachmentDTO.setTaskId("1");
*/		return attachmentDTO;
	}
	
	
	public Attachment convert(AttachmentDTO attachmentDto) {

		Attachment attachment = new Attachment();
		attachment.setAttachmentId(attachmentDto.getAttachmentId());
		attachment.setName(attachmentDto.getName());
		attachment.setFileData(attachmentDto.getFileData());
		attachment.setRequestId(attachmentDto.getRequestId());
		attachment.setCreatedBy(attachmentDto.getCreatedBy());
		attachment.setCreatedOn(attachmentDto.getCreatedOn());
		attachment.setStatus(attachmentDto.getStatus());
		attachment.setDescription(attachmentDto.getDescription());
		attachment.setType(attachmentDto.getType());
	//	attachment.setTaskId("1");
		return attachment;
	}

}
